/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.service.managedsystem.fru.persist;

import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdFileRecord;
import com.ibm.hwmca.base.vpdmgr.VpdFruData;
import com.ibm.hwmca.base.vpdmgr.VpdInputData;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementFilter;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.managedsystem.fru.filter.AllFrusFilter;
import com.ibm.hwmca.fw.service.managedsystem.persist.ServiceableElementPersistence;
import com.ibm.hwmca.fw.service.managedsystem.persist.ServiceableElementPersistenceException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FruPersistenceFromVPD
implements ServiceableElementPersistence {
    private static final String TRACE_MASKT = "XRVB05AT";
    private static final String TRACE_MASKF = "XRVB05AF";
    private static final String TRACE_MASKD = "XRVB05AD";

    public FruPersistenceFromVPD() {
        Trace.trace(TRACE_MASKT, "<> FruPersistenceFromVPD ctor");
    }

    public void init(Map initData) {
        Trace.trace(TRACE_MASKT, "<> FruPersistenceFromVPD.init( initData:" + initData + ")");
    }

    public void store(ServiceableElement element) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> FruPersistenceFromVPD.store(element: " + element + ")");
        Fru fru = null;
        if (element instanceof Fru) {
            fru = (Fru)element;
            VpdData vpdData = new VpdData(VpdRequestValue.ALTER);
            VpdInputData vpdInputData = new VpdInputData();
            vpdInputData.setFruLocation((String)fru.getProperties().get("LOCATION"));
            VpdFruData vpdFruData = new VpdFruData();
            vpdFruData.setEcLevel((String)fru.getProperties().get("EC_LEVEL"));
            vpdFruData.setPartNumber((String)fru.getProperties().get("PART_NUM"));
            vpdFruData.setSerialNumber((String)fru.getProperties().get("SERIAL_NUM"));
            vpdData.setVpdFruNewData(vpdFruData);
            vpdData.setVpdInputData(vpdInputData);
            VpdManager vpdManager = VpdManager.getVpdManager();
            try {
                VpdData vpdOutput = vpdManager.callVpdManager(vpdData);
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "<-! FruPersistenceFromVPD.store, vpd exception caught[" + e + "]");
                throw new ServiceableElementPersistenceException(e);
            }
        } else {
            Trace.trace(TRACE_MASKT, "!! FruPersistenceFromVPD.store - input element NOT a FRU - ignoring");
        }
        Trace.trace(TRACE_MASKT, "<- FruPersistenceFromVPD.store(element)");
    }

    public void store(List list) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> FruPersistenceFromVPD.store(List)");
        Iterator i = list.iterator();
        while (i.hasNext()) {
            this.store((ServiceableElement)i.next());
        }
        Trace.trace(TRACE_MASKT, "<- FruPersistenceFromVPD.store(List)");
    }

    public List load(ServiceableElementFilter filter) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> FruPersistenceFromVPD.load( filter: " + filter + ")");
        ArrayList<FruFromVPD> list = new ArrayList<FruFromVPD>();
        if (filter instanceof AllFrusFilter) {
            VpdData vpdData = new VpdData(VpdRequestValue.SEARCH_LOCATION);
            VpdInputData vpdInputData = new VpdInputData();
            vpdInputData.setFruLocation("*");
            vpdData.setVpdInputData(vpdInputData);
            VpdManager vpdManager = VpdManager.getVpdManager();
            try {
                VpdData vpdOutput = vpdManager.callVpdManager(vpdData);
                List vpdlist = vpdOutput.getSearchData();
                Trace.trace(TRACE_MASKD, "FruPersistenceFromVPD.load - number of elements found:" + vpdlist.size());
                Iterator i = vpdlist.iterator();
                boolean count = false;
                while (i.hasNext()) {
                    VpdFileRecord vpdFileRecord = (VpdFileRecord)i.next();
                    VpdFruData vpdFruData = vpdFileRecord.getFruFileData();
                    Trace.trace(TRACE_MASKD, "FruPersistenceFromVPD.load - vpdFileRecord.getFruLocation() = " + vpdFileRecord.getFruLocation());
                    Trace.trace(TRACE_MASKD, "FruPersistenceFromVPD.load - vpdFruData.getPartNumber() = " + vpdFruData.getPartNumber());
                    Trace.trace(TRACE_MASKD, "FruPersistenceFromVPD.load - vpdFruData.getSerialNumber() = " + vpdFruData.getSerialNumber());
                    Trace.trace(TRACE_MASKD, "FruPersistenceFromVPD.load - vpdFruData.getEcLevel() = " + vpdFruData.getEcLevel());
                    FruFromVPD fru = new FruFromVPD();
                    fru.getProperties().put("LOCATION", vpdFileRecord.getFruLocation());
                    fru.getProperties().put("EC_LEVEL", vpdFruData.getEcLevel());
                    fru.getProperties().put("PART_NUM", vpdFruData.getPartNumber());
                    fru.getProperties().put("SERIAL_NUM", vpdFruData.getSerialNumber());
                    fru.getProperties().put("OLD_EC_LEVEL", vpdFruData.getEcLevel());
                    fru.getProperties().put("OLD_PART_NUM", vpdFruData.getPartNumber());
                    fru.getProperties().put("OLD_SERIAL_NUM", vpdFruData.getSerialNumber());
                    fru.getProperties().put("CCIN", vpdFruData.getCcin());
                    fru.getProperties().put("INSTALL_TOD", vpdFruData.getTod());
                    list.add(fru);
                }
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "<-! FruPersistenceFromVPD.load, vpd exception caught[" + e + "]");
                throw new ServiceableElementPersistenceException(e);
            }
        } else {
            Trace.trace(TRACE_MASKT, "<-! FruPersistenceFromVPD.load; The only filter supported is LoadAllFrus.  Uunsupported filter passed: " + filter);
            throw new ServiceableElementPersistenceException("The only filter supported is LoadAllFrus.  Uunsupported filter passed: " + filter);
        }
        Trace.trace(TRACE_MASKT, "<- FruPersistenceFromVPD.load");
        return list;
    }

    public void remove(ServiceableElement element) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "<-! !! FruPersistenceFromVPD.remove(element) not supported");
        throw new ServiceableElementPersistenceException("FruPersistenceFromVPD.remove(element) not supported");
    }

    public void remove(List list) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "<-! !! FruPersistenceFromVPD.remove(List) not supported");
        throw new ServiceableElementPersistenceException("FruPersistenceFromVPD.remove(List) not supported");
    }

    public final String getType() {
        return "FRU";
    }

    private class FruFromVPD
    extends Fru {
    }
}

